#version 140
#extension GL_EXT_gpu_shader4 : enable
//Tchoutchou WawMod01.fsh  by Nashoute
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//thank you Iq https://iquilezles.org/articles/distfunctions
//and thank you GreenChicken for your tutorials https://www.shadertoy.com/user/GreenChicken

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float sdBox( vec3 p, vec3 b){
    vec3 q = abs(p) -b;
    return length(max(q,0.)) + min(max(q.x,max(q.y,q.z)),0.0);
}

float sdRoundBox( vec3 p, vec3 b, float r )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r;
}

vec3 opRepet(vec3 pos,vec3 bound){
    return mod(pos+0.5*bound,bound)-0.5*bound;
}

float opSmoothUnion( float d1, float d2, float k ) {
    float h = clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h); 
}

vec2 opSmoothUnionVec2( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h); 
}

vec2 opUnion( vec2 d1, vec2 d2 ) { 
    return (d1.x < d2.x) ? d1 : d2; 
}


float opSubtraction( float d1, float d2 ) { return max(-d1,d2); }

float opIntersection( float d1, float d2 ) { return max(d1,d2); }

vec2 map(vec3 pos){
    vec3 pos2 = pos;
    float offsetY = sin(pos2.x+iTime)/2.;
    float offsetz = sin(pos2.x+iTime)*1.2;
    vec2 world = vec2(pos.y+offsetY,0.0);
    
    pos = opRepet(pos, vec3(1.0,0.0,4.0));

    //float world = sdRoundBox(pos,vec3(0.05+sin(iTime+4.8)/8.+0.5,0.05+sin(iTime)/8.+0.3,0.05+sin(iTime)/8.+0.4),01.);
    vec2 planche = vec2(sdRoundBox(pos+vec3(0.0,offsetY-0.05,0.0-offsetz), vec3(0.2,0.005,0.8),0.05),0.5);
    vec2 rail1 = vec2(sdRoundBox(pos+vec3(0,offsetY-0.2,0.5-offsetz), vec3(1.,0.01,0.05),0.03),0.8);
    vec2 rail2 = vec2(sdRoundBox(pos+vec3(0,offsetY-0.2,-0.5-offsetz), vec3(1.,0.01,0.05),0.03),0.8);
    world = opUnion(world, planche);
    world = opUnion(world, rail1);
    world = opUnion(world, rail2);
    return world;
}

vec2 CastRay(vec3 ro, vec3 rd){
    float c = 0.0; //si y'a contact, on aura la distance
    
    for(int i = 0; i<128; i++){
    
        vec2 ray = map(ro + rd*c);
        
        if(ray.x < (0.005*c)){
            return vec2(float(i)/32.,ray.y);
        }
        
        c+=ray.x;
    }
    
    return vec2(-1.0, 0.0);
}

vec3 render(vec3 ro,vec3 rd){ //rayon origin, rayon direction
    
    vec2 contact = CastRay(ro,rd);         
    
    
    vec3 col = vec3(0.);
    
    if(contact.x == -1.){
        col = vec3(0.0);
        //col = palette(iTime,vec3(0.8,0.4,0.32),vec3(0.4,0.4,0.32),vec3(0.7,0.8,0.32),vec3(0.4,0.4,0.32));
    }else{
        col = vec3(1.-contact.x)*palette(contact.y+iTime/4.,vec3(0.5),vec3(0.5),vec3(1.),vec3(0.0,0.33,0.67) );
    }
    return col;
}


void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float fov = 2.; //fieldOfView
    vec2 uv = 2.*gl_FragCoord.xy/iResolution.xy-1.;
    uv.x*=iResolution.x/iResolution.y;
    
    //Camera
    vec3 cameraPos = vec3(3.,3.,5.);
    vec3 cameraTarget = vec3(0.,0.,0.);
    
    //view Direction/ RayD Direction
    vec3 forward = normalize(cameraTarget-cameraPos);
    vec3 right = normalize(cross(vec3(0.,-1.,0.),forward));
    vec3 up = normalize(cross(right,forward));
    vec3 viewDir = normalize(uv.x * right+uv.y*up+forward*fov);
    //viewDir.xy*=rot(iTime);

    
    vec3 col = vec3(uv.x,uv.y,0.0);
    
    col = render(cameraPos,viewDir);

    
    gl_FragColor = vec4(col,1.0);
    
}